const slides = document.querySelectorAll('.form-slide');
const nextBtns = document.querySelectorAll('.next-btn');
const prevBtns = document.querySelectorAll('.prev-btn');
const progressBar = document.querySelector('.progress-bar');

let currentStep = 0;
const totalSteps = slides.length;

// Show the current step
function showStep(step) {
    slides.forEach((slide, index) => {
        if (index === step) {
            slide.classList.add('active');
        } else {
            slide.classList.remove('active');
        }
    });

    // Update progress bar
    const progress = ((step + 1) / totalSteps) * 100;
    progressBar.style.width = `${progress}%`;
}

// Move to the next slide
nextBtns.forEach((btn) => {
    btn.addEventListener('click', () => {
        if (currentStep < totalSteps - 1) {
            currentStep++;
            showStep(currentStep);
        }
    });
});

// Move to the previous slide
prevBtns.forEach((btn) => {
    btn.addEventListener('click', () => {
        if (currentStep > 0) {
            currentStep--;
            showStep(currentStep);
        }
    });
});

// Initialize the form with the first slide
showStep(currentStep);

// Form submission handler
document.getElementById('multi-step-form').addEventListener('submit', function (e) {
    


    
   
});
